*****************************************************************************
* PROGRAM: 30_towns_t6
* PROGRAMMER: Modified by Gina Li at MIT, Oct. 2015
* PURPOSE: Makes Table 6 of Angrist, Lavy (2001) and outputs table into .csv
*****************************************************************************
capture log close
clear all
cd "`directory'"

set more off


log using "Table6.log", replace

use table6_1_public_final, clear

matrix t6 = J(24,10,.)

replace male4= male5 if male4==.
replace male4= male6 if male4==.
replace male4 = 0 if male4==2


gen ole4 = (migyear4 > 1951 & migyear4 != . )
gen ole6 = (migyear6 > 1951 & migyear6 != . )
gen dadmiss = (dadedr4 == 99)
gen mommiss = (momedr4 == 99)
gen fammiss = (famsize4 <= 1)

replace dadedr4 = . if dadedr4 == 99
replace momedr4 = . if momedr4 == 99
replace famsize4 = . if famsize4 <= 1

gen b1983=(dobyear4==1983)
gen b1984=(dobyear4==1984)
gen b1985=(dobyear4>=1985)
gen married4 = mstatus4 == 2
gen age4 = 1994 - dobyear4
gen age4sq = age4 ^ 2

replace dobyear4 = . if dobyear4 < 1983

gen divorced4 = (mstatus4 == 4)
gen miss_av = (asafr_av == . & euram_av == . & isr_av == .)
keep if relig == 0

drop miss_av


foreach var in daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa {
         gen miss_`var' = (`var' == .)
         replace `var' = 0 if `var' == .
 }


reg hebsc4 treated if hebsc6 != .


matrix t6[1,1] = _b[treated]
matrix t6[2,1] = _se[treated]

reg hebsc4 treated if hebsc6 != ., cluster(school_rename)

matrix t6[3,1] = _se[treated]
matrix t6[4,1] = e(N)

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 if hebsc6 != .

matrix t6[1,2] = _b[treated]
matrix t6[2,2] = _se[treated]

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 if hebsc6 != ., cluster(school_rename)

matrix t6[3,2] = _se[treated]
matrix t6[4,2] = e(N)

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  if hebsc6 != .

matrix t6[1,3] = _b[treated]
matrix t6[2,3] = _se[treated]

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc6 != . , cluster(school_rename)

matrix t6[3,3] = _se[treated]
matrix t6[4,3] = e(N)

matrix t6[5,1] = _b[treated]
matrix t6[6,1] = _se[treated]

reg hebsc5 treated if hebsc4 != ., cluster(school_rename)

matrix t6[7,1] = _se[treated]
matrix t6[8,1] = e(N)

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != .

matrix t6[5,2] = _b[treated]
matrix t6[6,2] = _se[treated]

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != ., cluster(school_rename)

matrix t6[7,2] = _se[treated]
matrix t6[8,2] = e(N)

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != .

matrix t6[5,3] = _b[treated]
matrix t6[6,3] = _se[treated]

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != ., cluster(school_rename)

matrix t6[7,3] = _se[treated]
matrix t6[8,3] = e(N)

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  hebsc4

matrix t6[5,4] = _b[treated]
matrix t6[6,4] = _se[treated]

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  hebsc4, cluster(school_rename)

matrix t6[7,4] = _se[treated]
matrix t6[8,4] = e(N)

reg hebsc5 treated  hebsc4

matrix t6[5,5] = _b[treated]
matrix t6[6,5] = _se[treated]

reg hebsc5 treated  hebsc4, cluster(school_rename)

matrix t6[7,5] = _se[treated]
matrix t6[8,5] = e(N)

reg hebsc6 treated if hebsc4 != .

matrix t6[9,1] = _b[treated]
matrix t6[10,1] = _se[treated]

reg hebsc6 treated if hebsc4 != ., cluster(school_rename)

matrix t6[11,1] = _se[treated]
matrix t6[12,1] = e(N)

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != .

matrix t6[9,2] = _b[treated]
matrix t6[10,2] = _se[treated]

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != ., cluster(school_rename)

matrix t6[11,2] = _se[treated]
matrix t6[12,2] = e(N)

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != .

matrix t6[9,3] = _b[treated]
matrix t6[10,3] = _se[treated]

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != . , cluster(school_rename)

matrix t6[11,3] = _se[treated]
matrix t6[12,3] = e(N)

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  hebsc4

matrix t6[9,4] = _b[treated]
matrix t6[10,4] = _se[treated]

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  hebsc4, cluster(school_rename)


matrix t6[11,4] = _se[treated]
matrix t6[12,4] = e(N)

reg hebsc6 treated  hebsc4

matrix t6[9,5] = _b[treated]
matrix t6[10,5] = _se[treated]

reg hebsc6 treated  hebsc4, cluster(school_rename)


matrix t6[11,5] = _se[treated]
matrix t6[12,5] = e(N)







use table6_2_public_final, clear

replace male4= male5 if male4==.

replace male4= male6 if male4==.

replace male4 = 0 if male4==2

gen ole4 = (migyear4 > 1951 & migyear4 != . )
gen ole6 = (migyear6 > 1951 & migyear6 != . )
gen dadmiss = (dadedr4 == 99)
gen mommiss = (momedr4 == 99)
gen fammiss = (famsize4 <= 1)

replace dadedr4 = . if dadedr4 == 99
replace momedr4 = . if momedr4 == 99
replace famsize4 = . if famsize4 <= 1


gen b1983=(dobyear4==1983)
gen b1984=(dobyear4==1984)
gen b1985=(dobyear4>=1985)
gen married4 = mstatus4 == 2
gen age4 = 1994 - dobyear4

gen age4sq = age4 ^ 2

replace dobyear4 = . if dobyear4 < 1983

gen divorced4 = (mstatus4 == 4)
gen miss_av = (asafr_av == . & euram_av == . & isr_av == .)

keep if relig == 0


drop miss_av


foreach var in daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa {
         gen miss_`var' = (`var' == .)
         replace `var' = 0 if `var' == .
}


reg mathsc4 treated if mathsc6 != .


matrix t6[1,6] = _b[treated]
matrix t6[2,6] = _se[treated]

reg mathsc4 treated if mathsc6 != ., cluster(school_rename)


matrix t6[3,6] = _se[treated]
matrix t6[4,6] = e(N)

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 if mathsc6 != .


matrix t6[1,7] = _b[treated]
matrix t6[2,7] = _se[treated]

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 if mathsc6 != . , cluster(school_rename)


matrix t6[3,7] = _se[treated]
matrix t6[4,7] = e(N)

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc6 != . 

matrix t6[1,8] = _b[treated]
matrix t6[2,8] = _se[treated]

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc6 != . , cluster(school_rename)

matrix t6[3,8] = _se[treated]
matrix t6[4,8] = e(N)

reg mathsc5 treated if mathsc4 != .

 
matrix t6[5,6] = _b[treated]
matrix t6[6,6] = _se[treated]

reg mathsc5 treated if mathsc4 != ., cluster(school_rename)


matrix t6[7,6] = _se[treated]
matrix t6[8,6] = e(N)

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != .


matrix t6[5,7] = _b[treated]
matrix t6[6,7] = _se[treated]

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != ., cluster(school_rename)


matrix t6[7,7] = _se[treated]
matrix t6[8,7] = e(N)

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != . 

matrix t6[5,8] = _b[treated]
matrix t6[6,8] = _se[treated]

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != . , cluster(school_rename)

matrix t6[7,8] = _se[treated]
matrix t6[8,8] = e(N)

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  mathsc4

matrix t6[5,9] = _b[treated]
matrix t6[6,9] = _se[treated]

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  mathsc4, cluster(school_rename)

matrix t6[7,9] = _se[treated]
matrix t6[8,9] = e(N)

reg mathsc5 treated  mathsc4

matrix t6[5,10] = _b[treated]
matrix t6[6,10] = _se[treated]

reg mathsc5 treated  mathsc4, cluster(school_rename)


matrix t6[9,6] = _b[treated]
matrix t6[10,6] = _se[treated]

reg mathsc6 treated if mathsc4 != ., cluster(school_rename)


matrix t6[11,6] = _se[treated]
matrix t6[12,6] = e(N)

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != .

matrix t6[9,7] = _b[treated]
matrix t6[10,7] = _se[treated]

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != ., cluster(school_rename) 

matrix t6[11,7] = _se[treated]
matrix t6[12,7] = e(N)

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != . 

matrix t6[9,8] = _b[treated]
matrix t6[10,8] = _se[treated]

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != . , cluster(school_rename)

matrix t6[11,8] = _se[treated]
matrix t6[12,8] = e(N)

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  mathsc4

matrix t6[9,9] = _b[treated]
matrix t6[10,9] = _se[treated]

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  mathsc4, cluster(school_rename)

matrix t6[11,9] = _se[treated]
matrix t6[12,9] = e(N)

reg mathsc6 treated  mathsc4

 
matrix t6[9,10] = _b[treated]
matrix t6[10,10] = _se[treated]

reg mathsc6 treated  mathsc4, cluster(school_rename)

matrix t6[11,10] = _se[treated]
matrix t6[12,10] = e(N)
 
************* Matching
 
use table6_3_public_final, clear


reg hebsc4 treated if hebsc6 != .


matrix t6[13,1] = _b[treated]
matrix t6[14,1] = _se[treated]

reg hebsc4 treated if hebsc6 != ., cluster(school_rename)

matrix t6[15,1] = _se[treated]
matrix t6[16,1] = e(N)

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 if hebsc6 != .

matrix t6[13,2] = _b[treated]
matrix t6[14,2] = _se[treated]

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 if hebsc6 != . , cluster(school_rename)

matrix t6[15,2] = _se[treated]
matrix t6[16,2] = e(N)

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc6 != .

matrix t6[13,3] = _b[treated]
matrix t6[14,3] = _se[treated]

reg hebsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc6 != . , cluster(school_rename)


matrix t6[15,3] = _se[treated]
matrix t6[16,3] = e(N)

reg hebsc5 treated if hebsc4 != .

   
matrix t6[17,1] = _b[treated]
matrix t6[18,1] = _se[treated]

reg hebsc5 treated if hebsc4 != ., cluster(school_rename)


matrix t6[19,1] = _se[treated]
matrix t6[20,1] = e(N)

 
reg hebsc5 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != .

matrix t6[17,2] = _b[treated]
matrix t6[18,2] = _se[treated]

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != ., cluster(school_rename)

matrix t6[19,2] = _se[treated]
matrix t6[20,2] = e(N)

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != .

matrix t6[17,3] = _b[treated]
matrix t6[18,3] = _se[treated]

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != . , cluster(school_rename)


matrix t6[19,3] = _se[treated]
matrix t6[20,3] = e(N)
 
reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  hebsc4


matrix t6[17,4] = _b[treated]
matrix t6[18,4] = _se[treated]

reg hebsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  hebsc4, cluster(school_rename)


matrix t6[19,4] = _se[treated]
matrix t6[20,4] = e(N)
 
reg hebsc5 treated  hebsc4
  

matrix t6[17,5] = _b[treated]
matrix t6[18,5] = _se[treated]

reg hebsc5 treated  hebsc4, cluster(school_rename)


matrix t6[19,5] = _se[treated]
matrix t6[20,5] = e(N)

reg hebsc6 treated if hebsc4 != .
 

matrix t6[21,1] = _b[treated]
matrix t6[22,1] = _se[treated]

reg hebsc6 treated if hebsc4 != ., cluster(school_rename)


matrix t6[23,1] = _se[treated]
matrix t6[24,1] = e(N)

 
reg hebsc6 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != .


matrix t6[21,2] = _b[treated]
matrix t6[22,2] = _se[treated]

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 if hebsc4 != ., cluster(school_rename)


matrix t6[23,2] = _se[treated]
matrix t6[24,2] = e(N)
 
reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != .


matrix t6[21,3] = _b[treated]
matrix t6[22,3] = _se[treated]

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if hebsc4 != . , cluster(school_rename)


matrix t6[23,3] = _se[treated]
matrix t6[24,3] = e(N)
 
reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  hebsc4

matrix t6[21,4] = _b[treated]
matrix t6[22,4] = _se[treated]

reg hebsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* hebsc4, cluster(school_rename)


matrix t6[23,4] = _se[treated]
matrix t6[24,4] = e(N)

reg hebsc6 treated  hebsc4

matrix t6[21,5] = _b[treated]
matrix t6[22,5] = _se[treated]

reg hebsc6 treated  hebsc4, cluster(school_rename)


matrix t6[23,5] = _se[treated]
matrix t6[24,5] = e(N)

 
 
 
use table6_4_public_final, clear


reg mathsc4 treated if mathsc6 != .

matrix t6[13,6] = _b[treated]
matrix t6[14,6] = _se[treated]

reg mathsc4 treated if mathsc6 != ., cluster(school_rename)


matrix t6[15,6] = _se[treated]
matrix t6[16,6] = e(N)

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 if mathsc6 != .

matrix t6[13,7] = _b[treated]
matrix t6[14,7] = _se[treated]

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 if mathsc6 != . , cluster(school_rename)

matrix t6[15,7] = _se[treated]
matrix t6[16,7] = e(N)

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc6 != . 

matrix t6[13,8] = _b[treated]
matrix t6[14,8] = _se[treated]

reg mathsc4 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc6 != . , cluster(school_rename)


matrix t6[15,8] = _se[treated]
matrix t6[16,8] = e(N)
 
reg mathsc5 treated if mathsc4 != .


matrix t6[17,6] = _b[treated]
matrix t6[18,6] = _se[treated]

reg mathsc5 treated if mathsc4 != . , cluster(school_rename)

matrix t6[19,6] = _se[treated]
matrix t6[20,6] = e(N)

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != .

matrix t6[17,7] = _b[treated]
matrix t6[18,7] = _se[treated]

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != ., cluster(school_rename)


matrix t6[19,7] = _se[treated]
matrix t6[20,7] = e(N)
 
reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != .


matrix t6[17,8] = _b[treated]
matrix t6[18,8] = _se[treated]

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != . , cluster(school_rename)

matrix t6[19,8] = _se[treated]
matrix t6[20,8] = e(N)

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* mathsc4


matrix t6[17,9] = _b[treated]
matrix t6[18,9] = _se[treated]

reg mathsc5 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* mathsc4, cluster(school_rename)

matrix t6[19,9] = _se[treated]
matrix t6[20,9] = e(N)
 
reg mathsc5 treated  mathsc4


matrix t6[17,10] = _b[treated]
matrix t6[18,10] = _se[treated]

reg mathsc5 treated  mathsc4, cluster(school_rename)

matrix t6[19,10] = _se[treated]
matrix t6[20,10] = e(N) 

reg mathsc6 treated if mathsc4 != .

matrix t6[21,6] = _b[treated]
matrix t6[22,6] = _se[treated]

reg mathsc6 treated if mathsc4 != . , cluster(school_rename)

matrix t6[23,6] = _se[treated]
matrix t6[24,6] = e(N)
 
reg mathsc6 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != .

matrix t6[21,7] = _b[treated]
matrix t6[22,7] = _se[treated]

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 if mathsc4 != . , cluster(school_rename) 

matrix t6[23,7] = _se[treated]
matrix t6[24,7] = e(N)

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != .

matrix t6[21,8] = _b[treated]
matrix t6[22,8] = _se[treated]

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_* if mathsc4 != . , cluster(school_rename)

matrix t6[23,8] = _se[treated]
matrix t6[24,8] = e(N)
 
reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  mathsc4


matrix t6[21,9] = _b[treated]
matrix t6[22,9] = _se[treated]

reg mathsc6 treated male4 ole4 b1983 b1984 b1985 daded momed married4 divorced4 dadb_mis dadb_ea dadb_aea dadb_la dadb_aa miss_*  mathsc4, cluster(school_rename)


matrix t6[23,9] = _se[treated]
matrix t6[24,9] = e(N)

reg mathsc6 treated  mathsc4
     
matrix t6[21,10] = _b[treated]
matrix t6[22,10] = _se[treated]

reg mathsc6 treated  mathsc4, cluster(school_rename)

matrix t6[23,10] = _se[treated]
matrix t6[24,10] = e(N)

clear

svmat t6

outsheet using "table6_output", comma replace

log close


